<?php
include 'includes/header.php';
require_once '../config/database.php';

if (!is_admin()) {
    redirect('./login.php');
}

$database = new Database();
$db = $database->getConnection();

// Get statistics
$stats = [
    'total_cars' => $db->query("SELECT COUNT(*) FROM cars")->fetchColumn(),
    'available_cars' => $db->query("SELECT COUNT(*) FROM cars WHERE status = 'Available'")->fetchColumn(),
    'total_users' => $db->query("SELECT COUNT(*) FROM users")->fetchColumn(),
    'total_inquiries' => $db->query("SELECT COUNT(*) FROM inquiries WHERE status = 'New'")->fetchColumn(),
    'total_test_drives' => $db->query("SELECT COUNT(*) FROM test_drives WHERE status = 'Pending'")->fetchColumn()
];

// Get recent cars
$recent_cars = $db->query(
    "SELECT c.*, b.name as brand_name, m.name as model_name 
     FROM cars c 
     LEFT JOIN brands b ON c.brand_id = b.id 
     LEFT JOIN models m ON c.model_id = m.id 
     ORDER BY c.created_at DESC LIMIT 5"
)->fetchAll();

// Get recent inquiries
$recent_inquiries = $db->query(
    "SELECT i.*, u.first_name, u.last_name, c.title as car_title 
     FROM inquiries i 
     JOIN users u ON i.user_id = u.id 
     JOIN cars c ON i.car_id = c.id 
     ORDER BY i.created_at DESC LIMIT 5"
)->fetchAll();

// Get recent test drives
$recent_test_drives = $db->query(
    "SELECT t.*, u.first_name, u.last_name, c.title as car_title 
     FROM test_drives t 
     JOIN users u ON t.user_id = u.id 
     JOIN cars c ON t.car_id = c.id 
     ORDER BY t.created_at DESC LIMIT 5"
)->fetchAll();
?>

<div class="container-fluid py-4">
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="mb-4">Admin Dashboard</h2>
            
            <!-- Quick Actions -->
            <div class="mb-4">
                <a href="./add_car.php" class="btn btn-primary me-2">Add New Car</a>
                <a href="./manage_cars.php" class="btn btn-secondary me-2">Manage Cars</a>
                <a href="./manage_users.php" class="btn btn-info me-2">Manage Users</a>
                <a href="./manage_brands.php" class="btn btn-success me-2">Manage Brands</a>
                <a href="./manage_models.php" class="btn btn-warning">Manage Models</a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-4">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="card-title">Total Cars</h5>
                    <h2><?php echo $stats['total_cars']; ?></h2>
                    <p class="mb-0">Available: <?php echo $stats['available_cars']; ?></p>
                </div>
            </div>
        </div>
        
        <div class="col-md-3 mb-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">Total Users</h5>
                    <h2><?php echo $stats['total_users']; ?></h2>
                </div>
            </div>
        </div>
        
        <div class="col-md-3 mb-4">
            <div class="card bg-warning">
                <div class="card-body">
                    <h5 class="card-title">New Inquiries</h5>
                    <h2><?php echo $stats['total_inquiries']; ?></h2>
                </div>
            </div>
        </div>
        
        <div class="col-md-3 mb-4">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5 class="card-title">Pending Test Drives</h5>
                    <h2><?php echo $stats['total_test_drives']; ?></h2>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Cars -->
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Recent Cars</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Brand/Model</th>
                                    <th>Price</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_cars as $car): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($car['title']); ?></td>
                                        <td>
                                            <?php echo htmlspecialchars($car['brand_name']); ?> /
                                            <?php echo htmlspecialchars($car['model_name']); ?>
                                        </td>
                                        <td>$<?php echo number_format($car['price'], 2); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                echo $car['status'] === 'Available' ? 'success' : 
                                                    ($car['status'] === 'Reserved' ? 'warning' : 'secondary'); 
                                            ?>">
                                                <?php echo $car['status']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Inquiries -->
        <div class="col-md-6 mb-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Recent Inquiries</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Car</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_inquiries as $inquiry): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($inquiry['first_name'] . ' ' . $inquiry['last_name']); ?></td>
                                        <td><?php echo htmlspecialchars($inquiry['car_title']); ?></td>
                                        <td><?php echo date('M d, Y', strtotime($inquiry['created_at'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                echo $inquiry['status'] === 'New' ? 'danger' : 
                                                    ($inquiry['status'] === 'In Progress' ? 'warning' : 'success'); 
                                            ?>">
                                                <?php echo $inquiry['status']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Test Drives -->
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Recent Test Drives</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Car</th>
                                    <th>Date</th>
                                    <th>Time</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_test_drives as $test_drive): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($test_drive['first_name'] . ' ' . $test_drive['last_name']); ?></td>
                                        <td><?php echo htmlspecialchars($test_drive['car_title']); ?></td>
                                        <td><?php echo date('M d, Y', strtotime($test_drive['preferred_date'])); ?></td>
                                        <td><?php echo date('h:i A', strtotime($test_drive['preferred_time'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                echo $test_drive['status'] === 'Pending' ? 'warning' : 
                                                    ($test_drive['status'] === 'Approved' ? 'success' : 
                                                    ($test_drive['status'] === 'Completed' ? 'info' : 'danger')); 
                                            ?>">
                                                <?php echo $test_drive['status']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 